/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.core.resources.ResourcesPlugin;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.jobs.SonarLintLogOutput;
import org.sonarsource.sonarlint.core.StandaloneSonarLintEngineImpl;
import org.sonarsource.sonarlint.core.client.api.common.LogOutput;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;

public class StandaloneSonarLintClientFacade {
    private StandaloneSonarLintEngine client;

    private synchronized StandaloneSonarLintEngine getClient() {
        if (this.client == null) {
            SonarLintCorePlugin.getDefault().info("Starting standalone SonarLint engine");
            Enumeration pluginEntries = SonarLintCorePlugin.getDefault().getBundle().findEntries("/plugins", "*.jar", false);
            StandaloneGlobalConfiguration globalConfig = ((StandaloneGlobalConfiguration.Builder)((StandaloneGlobalConfiguration.Builder)StandaloneGlobalConfiguration.builder().addPlugins(pluginEntries != null ? Collections.list(pluginEntries).toArray(new URL[0]) : new URL[]{}).setWorkDir(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".sonarlint").append("default").toFile().toPath())).setLogOutput((LogOutput)new SonarLintLogOutput())).build();
            try {
                this.client = new StandaloneSonarLintEngineImpl(globalConfig);
            }
            catch (Throwable e) {
                SonarLintCorePlugin.getDefault().error("Unable to start SonarLint engine", e);
                this.client = null;
            }
        }
        return this.client;
    }

    public void startAnalysis(StandaloneAnalysisConfiguration config, IssueListener issueListener) {
        this.getClient().analyze(config, issueListener);
    }

    public String getHtmlRuleDescription(String ruleKey) {
        RuleDetails ruleDetails = this.getClient().getRuleDetails(ruleKey);
        return ruleDetails != null ? ruleDetails.getHtmlDescription() : "Not found";
    }

    public synchronized void stop() {
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }
}

